/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.sound;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import lotr.client.LOTRTickHandlerClient;
import lotr.client.render.LOTRWeatherRenderer;
import lotr.common.LOTRConfig;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.world.LOTRWorldProvider;
import lotr.common.world.biome.LOTRBiomeGenBarrowDowns;
import lotr.common.world.biome.LOTRBiomeGenBeach;
import lotr.common.world.biome.LOTRBiomeGenDeadMarshes;
import lotr.common.world.biome.LOTRBiomeGenDolGuldur;
import lotr.common.world.biome.LOTRBiomeGenFarHaradCoast;
import lotr.common.world.biome.LOTRBiomeGenLindonCoast;
import lotr.common.world.biome.LOTRBiomeGenMirkwoodCorrupted;
import lotr.common.world.biome.LOTRBiomeGenOcean;
import lotr.common.world.biome.LOTRBiomeGenOldForest;
import lotr.common.world.biome.LOTRBiomeGenUtumno;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.MinecraftForge;

public class LOTRAmbience {
    private int ticksSinceWight;
    private List<ISound> playingWindSounds = new ArrayList<ISound>();
    private List<ISound> playingSeaSounds = new ArrayList<ISound>();
    private ISound playingJazzMusic;
    private int jazzPlayerID;
    private static final ResourceLocation jazzMusicPath = new ResourceLocation("lotr:music.jazzelf");
    private static final String jazzMusicTitle = "The Galadhon Groovers - Funky Villagers";

    public LOTRAmbience() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent17 event) {
        String name = event.name;
        ISound sound = event.sound;
        if (LOTRConfig.newWeather && sound instanceof PositionedSound) {
            PositionedSound ps = (PositionedSound)sound;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && world.field_73011_w instanceof LOTRWorldProvider) {
                if (name.equals("ambient.weather.rain")) {
                    event.result = new PositionedSoundRecord(new ResourceLocation("lotr:ambient.weather.rain"), ps.func_147653_e(), ps.func_147655_f(), ps.func_147649_g(), ps.func_147654_h(), ps.func_147651_i());
                } else if (name.equals("ambient.weather.thunder")) {
                    event.result = new PositionedSoundRecord(new ResourceLocation("lotr:ambient.weather.thunder"), ps.func_147653_e(), ps.func_147655_f(), ps.func_147649_g(), ps.func_147654_h(), ps.func_147651_i());
                }
            }
        }
        if (this.playingJazzMusic != null && event.category == SoundCategory.MUSIC) {
            event.result = null;
            return;
        }
    }

    public void updateAmbience(World world, EntityPlayer entityplayer) {
        Minecraft mc;
        block42: {
            int xzRange;
            world.field_72984_F.func_76320_a("lotrAmbience");
            mc = Minecraft.func_71410_x();
            boolean enableAmbience = LOTRConfig.enableAmbience;
            boolean enableWeather = LOTRConfig.newWeather;
            double x = entityplayer.field_70165_t;
            double y = entityplayer.field_70121_D.field_72338_b;
            double z = entityplayer.field_70161_v;
            int i = MathHelper.func_76128_c((double)x);
            int j = MathHelper.func_76128_c((double)y);
            int k = MathHelper.func_76128_c((double)z);
            BiomeGenBase biome = world.func_72807_a(i, k);
            Random rand = world.field_73012_v;
            if (enableAmbience) {
                if (this.ticksSinceWight > 0) {
                    --this.ticksSinceWight;
                } else {
                    boolean wights;
                    boolean bl = wights = LOTRTickHandlerClient.anyWightsViewed && rand.nextInt(20) == 0 || biome instanceof LOTRBiomeGenBarrowDowns && rand.nextInt(3000) == 0;
                    if (wights) {
                        world.func_72980_b(x, y, z, "lotr:wight.ambience", 1.0f, 0.8f + rand.nextFloat() * 0.4f, false);
                        this.ticksSinceWight = 300;
                    }
                }
                boolean spookyBiomeNoise = false;
                float spookyPitch = 1.0f;
                if (biome instanceof LOTRBiomeGenDolGuldur) {
                    spookyBiomeNoise = rand.nextInt(1000) == 0;
                    spookyPitch = 0.85f;
                } else if (biome instanceof LOTRBiomeGenDeadMarshes) {
                    spookyBiomeNoise = rand.nextInt(2400) == 0;
                } else if (biome instanceof LOTRBiomeGenMirkwoodCorrupted) {
                    spookyBiomeNoise = rand.nextInt(3000) == 0;
                } else if (biome instanceof LOTRBiomeGenOldForest) {
                    spookyBiomeNoise = rand.nextInt(6000) == 0;
                } else if (biome instanceof LOTRBiomeGenUtumno) {
                    spookyBiomeNoise = rand.nextInt(1000) == 0;
                    spookyPitch = 0.75f;
                }
                if (spookyBiomeNoise) {
                    world.func_72980_b(x, y, z, "lotr:wight.ambience", 1.0f, (0.8f + rand.nextFloat() * 0.4f) * spookyPitch, false);
                }
                if (biome instanceof LOTRBiomeGenUtumno && world.field_73012_v.nextInt(500) == 0) {
                    world.func_72980_b(x, y, z, "ambient.cave.cave", 1.0f, 0.8f + rand.nextFloat() * 0.2f, false);
                }
            }
            if (enableWeather && world.field_73011_w instanceof LOTRWorldProvider) {
                if (this.playingWindSounds.size() < 4) {
                    xzRange = 16;
                    int minWindHeight = 100;
                    int fullWindHeight = 180;
                    if (rand.nextInt(20) == 0) {
                        minWindHeight -= 10;
                        if (rand.nextInt(10) == 0) {
                            minWindHeight -= 10;
                        }
                    }
                    if (world.func_72896_J()) {
                        minWindHeight = 80;
                        fullWindHeight = 120;
                        if (rand.nextInt(20) == 0) {
                            minWindHeight -= 20;
                        }
                        if (LOTRWeatherRenderer.isSandstormBiome(biome)) {
                            minWindHeight = 60;
                            fullWindHeight = 80;
                        }
                    }
                    for (int l = 0; l < 2; ++l) {
                        float f;
                        int i1 = i + MathHelper.func_76136_a((Random)rand, (int)(-xzRange), (int)xzRange);
                        int k1 = k + MathHelper.func_76136_a((Random)rand, (int)(-xzRange), (int)xzRange);
                        int j1 = j + MathHelper.func_76136_a((Random)rand, (int)-16, (int)16);
                        if (j1 < minWindHeight || !world.func_72937_j(i1, j1, k1)) continue;
                        float windiness = (float)(j1 - minWindHeight) / (float)(fullWindHeight - minWindHeight);
                        windiness = MathHelper.func_76131_a((float)windiness, (float)0.0f, (float)1.0f);
                        if (f < rand.nextFloat()) continue;
                        float x1 = (float)i1 + 0.5f;
                        float y1 = (float)j1 + 0.5f;
                        float z1 = (float)k1 + 0.5f;
                        float vol = 1.0f * Math.max(0.25f, windiness);
                        float pitch = 0.8f + rand.nextFloat() * 0.4f;
                        AmbientSoundNoAttentuation wind = new AmbientSoundNoAttentuation(new ResourceLocation("lotr:ambient.weather.wind"), vol, pitch, x1, y1, z1).calcAmbientVolume(entityplayer, xzRange);
                        mc.func_147118_V().func_147682_a((ISound)wind);
                        this.playingWindSounds.add((ISound)wind);
                        break;
                    }
                } else {
                    HashSet<ISound> removes = new HashSet<ISound>();
                    for (ISound wind : this.playingWindSounds) {
                        if (mc.func_147118_V().func_147692_c(wind)) continue;
                        removes.add(wind);
                    }
                    this.playingWindSounds.removeAll(removes);
                }
            }
            if (enableAmbience) {
                if (this.playingSeaSounds.size() < 3) {
                    if (biome instanceof LOTRBiomeGenOcean || biome instanceof LOTRBiomeGenBeach || biome instanceof LOTRBiomeGenLindonCoast || biome instanceof LOTRBiomeGenFarHaradCoast) {
                        xzRange = 64;
                        for (float fr : new float[]{0.25f, 0.5f, 0.75f, 1.0f}) {
                            int range = (int)((float)xzRange * fr);
                            for (int l = 0; l < 8; ++l) {
                                int i1 = i + MathHelper.func_76136_a((Random)rand, (int)(-range), (int)range);
                                int k1 = k + MathHelper.func_76136_a((Random)rand, (int)(-range), (int)range);
                                int j1 = j + MathHelper.func_76136_a((Random)rand, (int)-16, (int)8);
                                Block block = world.func_147439_a(i1, j1, k1);
                                if (block.func_149688_o() != Material.field_151586_h || j1 < world.func_72825_h(i1, k1)) continue;
                                float x1 = (float)i1 + 0.5f;
                                float y1 = (float)j1 + 0.5f;
                                float z1 = (float)k1 + 0.5f;
                                float vol = 1.0f;
                                float pitch = 0.8f + rand.nextFloat() * 0.4f;
                                AmbientSoundNoAttentuation sea = new AmbientSoundNoAttentuation(new ResourceLocation("lotr:ambient.terrain.sea"), vol, pitch, x1, y1, z1).calcAmbientVolume(entityplayer, xzRange);
                                mc.func_147118_V().func_147682_a((ISound)sea);
                                this.playingSeaSounds.add((ISound)sea);
                                int j2 = world.func_72976_f(i1, k1) - 1;
                                if (world.func_147439_a(i1, j2, k1).func_149688_o() == Material.field_151586_h) {
                                    double dx = (double)i1 + 0.5 - entityplayer.field_70165_t;
                                    double dz = (double)k1 + 0.5 - entityplayer.field_70161_v;
                                    float angle = (float)Math.atan2(dz, dx);
                                    float cos = MathHelper.func_76134_b((float)angle);
                                    float sin = MathHelper.func_76126_a((float)angle);
                                    float angle90 = angle + (float)Math.toRadians(-90.0);
                                    float cos90 = MathHelper.func_76134_b((float)angle90);
                                    float sin90 = MathHelper.func_76126_a((float)angle90);
                                    float waveSpeed = MathHelper.func_151240_a((Random)rand, (float)0.3f, (float)0.5f);
                                    int waveR = 40 + rand.nextInt(100);
                                    for (int w = -waveR; w <= waveR; ++w) {
                                        float f = (float)w / 8.0f;
                                        double d0 = (double)i1 + 0.5;
                                        double d1 = (double)j2 + 1.0 + (double)MathHelper.func_151240_a((Random)rand, (float)0.02f, (float)0.1f);
                                        double d2 = (double)k1 + 0.5;
                                        if (world.func_147439_a(MathHelper.func_76128_c((double)(d0 += (double)(f * cos90))), MathHelper.func_76128_c((double)d1) - 1, MathHelper.func_76128_c((double)(d2 += (double)(f * sin90)))).func_149688_o() != Material.field_151586_h) continue;
                                        double d3 = waveSpeed * -cos;
                                        double d4 = 0.0;
                                        double d5 = waveSpeed * -sin;
                                        LOTRMod.proxy.spawnParticle("wave", d0, d1, d2, d3, d4, d5);
                                    }
                                }
                                break block42;
                            }
                        }
                    }
                } else {
                    HashSet<ISound> removes = new HashSet<ISound>();
                    for (ISound sea : this.playingSeaSounds) {
                        if (mc.func_147118_V().func_147692_c(sea)) continue;
                        removes.add(sea);
                    }
                    this.playingSeaSounds.removeAll(removes);
                }
            }
        }
        if (this.playingJazzMusic == null) {
            if (entityplayer.field_70173_aa % 20 == 0) {
                double range = 16.0;
                List elves = world.func_72872_a(LOTREntityElf.class, entityplayer.field_70121_D.func_72314_b(range, range, range));
                LOTREntityElf playingElf = null;
                for (Object obj : elves) {
                    LOTREntityElf elf = (LOTREntityElf)obj;
                    if (!elf.func_70089_S() || !elf.isJazz() || !elf.isSolo()) continue;
                    playingElf = elf;
                    break;
                }
                if (playingElf != null) {
                    mc.func_147118_V().func_147690_c();
                    this.jazzPlayerID = playingElf.func_145782_y();
                    ISound music = this.getJazzMusic((Entity)playingElf);
                    mc.func_147118_V().func_147682_a(music);
                    this.playingJazzMusic = music;
                    mc.field_71456_v.func_73833_a(jazzMusicTitle);
                }
            }
        } else {
            Entity player = world.func_73045_a(this.jazzPlayerID);
            if (player == null || !player.func_70089_S()) {
                mc.func_147118_V().func_147683_b(this.playingJazzMusic);
                this.playingJazzMusic = null;
            }
            if (!mc.func_147118_V().func_147692_c(this.playingJazzMusic)) {
                this.playingJazzMusic = null;
            }
        }
        world.field_72984_F.func_76319_b();
    }

    private ISound getJazzMusic(Entity entity) {
        return PositionedSoundRecord.func_147675_a((ResourceLocation)jazzMusicPath, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v));
    }

    private static class AmbientSoundNoAttentuation
    extends PositionedSoundRecord {
        public AmbientSoundNoAttentuation(ResourceLocation sound, float vol, float pitch, float x, float y, float z) {
            super(sound, vol, pitch, x, y, z);
            this.field_147666_i = ISound.AttenuationType.NONE;
        }

        public AmbientSoundNoAttentuation calcAmbientVolume(EntityPlayer entityplayer, int maxRange) {
            float distFr = (float)entityplayer.func_70011_f((double)this.field_147660_d, (double)this.field_147661_e, (double)this.field_147658_f);
            distFr /= (float)maxRange;
            distFr = Math.min(distFr, 1.0f);
            distFr = 1.0f - distFr;
            distFr *= 1.5f;
            distFr = MathHelper.func_76131_a((float)distFr, (float)0.1f, (float)1.0f);
            this.field_147662_b *= distFr;
            return this;
        }
    }
}

